Ext.data.JsonP.sol_common_monitoring_as_collectors_ChildrenCollector({"tagname":"class","name":"sol.common_monitoring.as.collectors.ChildrenCollector","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common_monitoring.as.collectors.ChildrenCollector.js","href":"lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.02.000"],"eloas":true,"requires":["sol.common.Map","sol.common.RepoUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"cleanupParentMap","tagname":"cfg","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"cfg-cleanupParentMap","meta":{}},{"name":"cleanupReferences","tagname":"cfg","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"cfg-cleanupReferences","meta":{}},{"name":"findChildrenCfg","tagname":"cfg","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"cfg-findChildrenCfg","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"cfg-objId","meta":{"required":true}},{"name":"readParentMap","tagname":"cfg","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"cfg-readParentMap","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"defaultFindChildrenCfg","tagname":"property","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"property-defaultFindChildrenCfg","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"cleanupMap","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-cleanupMap","meta":{"private":true}},{"name":"deleteReference","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-deleteReference","meta":{"private":true}},{"name":"dispose","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-dispose","meta":{}},{"name":"getContext","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-getContext","meta":{}},{"name":"getParentMap","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-getParentMap","meta":{"private":true}},{"name":"getResults","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-getResults","meta":{}},{"name":"hasMoreResults","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-hasMoreResults","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-initialize","meta":{"private":true}},{"name":"postProcess","tagname":"method","owner":"sol.common_monitoring.as.collectors.ChildrenCollector","id":"method-postProcess","meta":{}}],"code_type":"ext_define","id":"class-sol.common_monitoring.as.collectors.ChildrenCollector","short_doc":"Collects all elements within a specified folder. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common_monitoring.as.collectors.ChildrenCollector</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Map' rel='sol.common.Map' class='docClass'>sol.common.Map</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector' target='_blank'>lib_sol.common_monitoring.as.collectors.ChildrenCollector.js</a></div></pre><div class='doc-contents'><p>Collects all elements within a specified folder.</p>\n\n<p>In addition this collector provides a <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-getContext\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-method-getContext\" class=\"docClass\">getContext</a> methode to deliver some context about the collector to the analyzers.\nCurrently only a <code>parentMap</code> property of type <a href=\"#!/api/sol.common.SordMap\" rel=\"sol.common.SordMap\" class=\"docClass\">sol.common.SordMap</a> will be provided if <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap\" class=\"docClass\">readParentMap</a> is configured.</p>\n\n<h1>Example</h1>\n\n<p>This collector will return all child elements in one batch and it is not possible to use paging.</p>\n\n<pre><code>var updateCollector = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector\" class=\"docClass\">sol.common_monitoring.as.collectors.ChildrenCollector</a>\", {\n  objId: \"ARCPATH:¶Job queues¶Updates\"\n});\n</code></pre>\n\n<h1>Post processing</h1>\n\n<p>In post processing the references in the folder will be deleted if</p>\n\n<p>a) <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupReferences\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupReferences\" class=\"docClass\">cleanupReferences</a> is set to <code>true</code> (priority over analyzer results)</p>\n\n<p>b) the analyzer returns at least one <code>result</code> with a property <code>cleanupRef</code> set to <code>true</code></p>\n      <p class='version-tag'>Version: <b>1.02.000</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-objId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>The folder which should be watched</p>\n</div><div class='long'><p>The folder which should be watched</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-cleanupParentMap' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-cfg-cleanupParentMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupParentMap' class='name expandable'>cleanupParentMap</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional) If <code>true</code>, all checked out parent map values will be deleted.</p>\n</div><div class='long'><p>(optional) If <code>true</code>, all checked out parent map values will be deleted.</p>\n</div></div></div><div id='cfg-cleanupReferences' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-cfg-cleanupReferences' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupReferences' class='name expandable'>cleanupReferences</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional) If <code>true</code>, all references will be deleted, regardless the results.</p>\n</div><div class='long'><p>(optional) If <code>true</code>, all references will be deleted, regardless the results.</p>\n</div></div></div><div id='cfg-findChildrenCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-cfg-findChildrenCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-findChildrenCfg' class='name expandable'>findChildrenCfg</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) See sol.common.RepoUtils.findChildren. ...</div><div class='long'><p>(optional) See <a href=\"#!/api/sol.common.RepoUtils-method-findChildren\" rel=\"sol.common.RepoUtils-method-findChildren\" class=\"docClass\">sol.common.RepoUtils.findChildren</a>. The default would be <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-property-defaultFindChildrenCfg\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-property-defaultFindChildrenCfg\" class=\"docClass\">defaultFindChildrenCfg</a>.</p>\n</div></div></div><div id='cfg-readParentMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-cfg-readParentMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap' class='name expandable'>readParentMap</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf This contains keys, all map fields from the parent map will be checked out, which start with those keys. ...</div><div class='long'><p>(optional)\nIf This contains keys, all map fields from the parent map will be checked out, which start with those keys.\nThe keys in the parent map must have an dot and the objId appended, otherwise they could not be mazched to the corresonding child element.</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-defaultFindChildrenCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-property-defaultFindChildrenCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-property-defaultFindChildrenCfg' class='name expandable'>defaultFindChildrenCfg</a> : de.elo.ix.client.SordZ<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-cleanupMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-cleanupMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-cleanupMap' class='name expandable'>cleanupMap</a>( <span class='pre'>sord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Removes all entries from the parent map if configured (see cleanupParentMap). ...</div><div class='long'><p>Removes all entries from the parent map if configured (see <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupParentMap\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupParentMap\" class=\"docClass\">cleanupParentMap</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-deleteReference' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-deleteReference' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-deleteReference' class='name expandable'>deleteReference</a>( <span class='pre'>sord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Deletes a Reference fron the watched folder. ...</div><div class='long'><p>Deletes a Reference fron the watched folder.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-dispose' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-dispose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-dispose' class='name expandable'>dispose</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Performes cleanup by removing the current working set. ...</div><div class='long'><p>Performes cleanup by removing the current working set.</p>\n</div></div></div><div id='method-getContext' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-getContext' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-getContext' class='name expandable'>getContext</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a prefilled context object if readParentMap defines at least one map key. ...</div><div class='long'><p>Returns a prefilled context object if <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap\" class=\"docClass\">readParentMap</a> defines at least one map key.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getParentMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-getParentMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-getParentMap' class='name expandable'>getParentMap</a>( <span class='pre'></span> ) : <a href=\"#!/api/sol.common.SordMap\" rel=\"sol.common.SordMap\" class=\"docClass\">sol.common.SordMap</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrives the parent map if configured. ...</div><div class='long'><p>Retrives the parent map if configured.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/sol.common.SordMap\" rel=\"sol.common.SordMap\" class=\"docClass\">sol.common.SordMap</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getResults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-getResults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-getResults' class='name expandable'>getResults</a>( <span class='pre'></span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the next batch of work items. ...</div><div class='long'><p>Retrieves the next batch of work items.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasMoreResults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-hasMoreResults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-hasMoreResults' class='name expandable'>hasMoreResults</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if this collector has additional results. ...</div><div class='long'><p>Checks, if this collector has additional results.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-postProcess' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.collectors.ChildrenCollector'>sol.common_monitoring.as.collectors.ChildrenCollector</span><br/><a href='source/lib_sol.common_monitoring.as.collectors.ChildrenCollector.html#sol-common_monitoring-as-collectors-ChildrenCollector-method-postProcess' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-method-postProcess' class='name expandable'>postProcess</a>( <span class='pre'>sord, results, ctx</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This collector removes the references to a sord in the watched folder if cleanupReferences is set to true or one of t...</div><div class='long'><p>This collector removes the references to a sord in the watched folder if <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupReferences\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupReferences\" class=\"docClass\">cleanupReferences</a> is set to <code>true</code> or one of the <code>results</code> defines a <code>cleanupRef</code> flag.\nIf <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupParentMap\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-cleanupParentMap\" class=\"docClass\">cleanupParentMap</a> is set to <code>true</code> the parent map entries will be deleted (see <a href=\"#!/api/sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap\" rel=\"sol.common_monitoring.as.collectors.ChildrenCollector-cfg-readParentMap\" class=\"docClass\">readParentMap</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>results</span> : Object[]<div class='sub-desc'><p>The result object returned by an <code>analyzer</code></p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'><p>Context object</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});